//
//  Transaction.m
//  ABC Bank
//
//  Created by oliviers on 10/13/13.
//  Copyright (c) 2013 Cisco Systems, Inc. All rights reserved.
//

#import "Transaction.h"

@implementation Transaction
@synthesize itemName, transactionId, amount, dateCreated;

+ (id)randomItem:(int)randomValue
{
    NSArray *purchaseTypeList = [NSArray arrayWithObjects:@"Groceries",
                                 @"Gas",
                                 @"Clothes",
                                 @"Entertainment",
                                 @"Health",
                                 @"On-line Bill pay",
                                 nil];
    
    int lowerBound = -100;
    int upperBound = 100;
    int randomVal = lowerBound + randomValue % (upperBound - lowerBound);
    
    // Get the index of a random adjective/noun from the lists
    // Note: The % operator, called the modulo operator, gives
    // you the remainder. So adjectiveIndex is a random number
    // from 0 to 2 inclusive.
    NSInteger purchaseTypeIndex = rand() % [purchaseTypeList count];
    
    // Note that NSInteger is not an object, but a type definition
    // for "unsigned long"
    NSString *randomName = [NSString stringWithFormat:@"%@ %@", (randomVal > 0) ? @"Deposit" : @"Purchase:",
                                                                (randomVal > 0) ? @"" : [purchaseTypeList objectAtIndex:purchaseTypeIndex]];
    
    
    
    NSString *randomTransactionId = [NSString stringWithFormat:@"%c%c%c%c%c", '0' + rand() % 10, 'A' + rand() % 26, '0' + rand() % 10, 'A' + rand() % 26, '0' + rand() % 10];
    
    Transaction *newItem = [[self alloc] initWithItemName:randomName amount:[NSNumber numberWithInt:randomVal] transactionId:randomTransactionId];
    return newItem;
}

- (id)initWithItemName:(NSString*)name
                amount:(NSNumber*)initAmount
         transactionId:(NSString*)tId
{
    self = [super init];
    if(self){
        [self setItemName:name];
        [self setTransactionId:tId];
        [self setAmount:initAmount];
        dateCreated = [[NSDate alloc] init];
    }
    return self;
}
@end
